using System;
using System.Data;
using System.Data.OleDb;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;



using gov.va.med.vbecs;
using gov.va.med.vbecs.GUI.controls;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmPatientSelect
	/// </summary>
	public class FrmPatientSelect : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private bool _searchVistaLink;
		private BOL.Patient patient;

		private System.Windows.Forms.Button btnCancel;
		private System.ComponentModel.IContainer components = null;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		
		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="searchVistaLink"></param>
		public FrmPatientSelect( bool searchVistaLink )
		{
			InitializeComponent();
			
			SetComponentProperties();

			_searchVistaLink = searchVistaLink;
			patient = new BOL.Patient();
			this.patientSelectTool1.SearchVistaLink = searchVistaLink;
			
            //Attach events so user activity resets lock idle time
            this.patientSelectTool1.UserActivity += new EventHandler(this.ResetLockTimer);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnCancel = new System.Windows.Forms.Button();
			this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(688, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Patient Search";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 477);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 4;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.FlatStyle = System.Windows.Forms.FlatStyle.System;
			this.btnCancel.Location = new System.Drawing.Point(608, 464);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// patientSelectTool1
			// 
			this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientSelectTool1.DisplaySIAndTRs = true;
			this.patientSelectTool1.EnabledBloodAvailButton = false;
			this.patientSelectTool1.EnabledMedicationButton = false;
			this.patientSelectTool1.EnabledRecentOrdersButton = false;
			this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientSelectTool1.EnabledSIAndTRButton = false;
			this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
			this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientSelectTool1.Location = new System.Drawing.Point(4, 32);
			this.patientSelectTool1.Name = "patientSelectTool1";
			this.patientSelectTool1.SearchVistaLink = false;
			this.patientSelectTool1.Size = new System.Drawing.Size(678, 424);
			this.patientSelectTool1.TabIndex = 0;
			this.patientSelectTool1.DoubleClick += new System.EventHandler(this.patientSelectTool1_DoubleClick);
			this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
			this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(528, 464);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.patientSelectTool1_DoubleClick);
			// 
			// FrmPatientSelect
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(688, 493);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.patientSelectTool1);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Patient_Selection.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(696, 480);
			this.Name = "FrmPatientSelect";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.Text = "VBECS - Patient Search";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmPatientSelect_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.patientSelectTool1, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Get SelectedPatient
		/// </summary>
		public BOL.Patient SelectedPatient
		{
			get { return patient; }
		}

		#endregion

		private void SetComponentProperties()
		{
			vbecsLogo1.Title="Patient Search";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
		}

		#region Events

		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			patient = (BOL.Patient)patientSelectTool1.SelectedPatient.Clone();
			//BR_1.67
			//Alert the user that the patient is deceased
			
			btnOK.EnabledButton = true;
		}

		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			patient = new BOL.Patient();
			btnOK.EnabledButton = false;
		}

		private void patientSelectTool1_DoubleClick(object sender, System.EventArgs e)
		{
			// searchVistaLink: don't make a trip to the DB if it's not needed:
			if( _searchVistaLink && this.patientSelectTool1.SelectedPatientDataRow() != null )
			{
				bool success = BOL.Patient.InsertPatient( this.patientSelectTool1.SelectedPatientDataRow(), Common.UpdateFunction.UC001FrmPatientSelect );
				//
				if (!success)
				{
					GuiMessenger.ShowMessageBox(this,Common.StrRes.SysErrMsg.Common.InsertPatientFail());
					return;
				}
			}

			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmPatientSelect_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			this.SpeakMessage( this.patientSelectTool1.GetErrorMessagesFor508() );		
		}

		#endregion
	}
}
